# 실수 표현(고정소수점 & 부동소수점)

컴퓨터는 기계어를 사용하여 모든 정보를 0과 1의 2진수로 처리한다.  
컴퓨터는 실수를 표현하기 위해 `고정 소수점`과 `부동 소수점` 방식을 사용한다.

## 이진기수법

고정 소수점과 부동 소수점 표현 방식 모두 이진법에 기반하기 때문에, 고정 소수점과 부동 소수점 사용 이전 실수의 각 부분을 이진수의 형태로 변환해야한다.

![decimal float to binary](https://user-images.githubusercontent.com/66757141/207567225-f4db8d8c-4e76-4f26-9179-2c6a379abae8.png)

_[Image Ref | generalnote.com](http://generalnote.com/Computer-Fundamental/Number-System/Converting-Decimal-Integer-Fraction-to-Binary-Octal-Hexadecimal.php)_

> 앞으로의 예시에서 다룰 -123.125 를 이진법으로 표현하면 -1111011.001(2) 이다.

<br/>

## 고정소수점(Fixed Point)

**고정 소수점(Fixed point)** 은 이름 그대로 소수점이 **고정**되었다는 의미이다.  
고정 소수점 표현 방식은 `부호비트`, `정수부`, `소수부`로 구성되어있다.

<img src="https://user-images.githubusercontent.com/66757141/207578670-0d013e5e-103f-413e-9641-00424648466b.png" alt="fixed point" width ="600"/>


- **부호비트** (Sign Bit)는 맨 앞 `1bit`로 `0`은 양수를, `1`은 음수를 의미한다.  
- 소수점의 위치를 중앙으로 고정하여, 앞을 정수부 뒤를 소수부로 채운다.
- `32bit` 체계를 생각했을 때 소수점의 위치를 기준으로 앞의 `15bit`에는 정수부를 뒤의 `16bit`에는 소수부를 채운다.
  > `-123.125`의 예시를 보면 부호비트는 음수이므로 `1`, 앞서 이진수로 변환한 값 `-1111011.001(2)`의 정수부와 소수부가 고정된 소수점을 기준으로 들어가있는 형태이다.
- 고정 소수점 방식은 표현하는 과정은 편리하지만, 정수부와 소수부의 자릿수 제한으로 표현 가능한 수의 범위 및 정밀도가 떨어지기 때문에 잘 사용되지 않는다.

<br/>

## 부동소수점(Floating Point)

**부동소수점(Floating point)** 에서 부동은 浮動(뜰 부, 움직일 동)이며, 소수점이 **유동적**이라는 의미이다.   

IEEE 754는 전기 전자 기술자 협회(IEEE)에서 개발한 컴퓨터에서 부동소수점을 표현하는 가장 널리 쓰이는 표준으로 실수를 저장하는 데는 `32bit` 또는 `64bit`를 사용한다.  
IEEE 754의 부동 소수점 표현 방식은 `부호비트`, `지수부분(exponent)`과 `가수부분(fraction/mantissa)`으로 구성되어있다.

<img src="https://user-images.githubusercontent.com/66757141/207578698-d908f5eb-2ce8-4866-b7ae-3f81eaa3bed0.png" alt="floating point" width ="600"/>

- **부호비트** (Sign Bit)는 맨 앞 `1bit`로 `0`은 양수를, `1`은 음수를 의미한다.
- 부동소수점은 실수를 정규화 하여 지수부와 가수부로 표현한다.


### 정규화(Normalization)
부동소수점에서 정규화란 정수부가 1이 되도록 다음과 같이 소수점을 옮기고 2^x를 곱하는 형태로 변환하여 표현하는 것이다.

$$
num = 1.x * 2^n\\
ex) -123.125=-1.23125*2^n
$$

- **가수부** 에는 정규화한 값의 소수점 아래 값들을 입력한다. 정규화를 한 결과의 정수부는 무조건 1이기 때문에 제외하며, 이를 `hidden bit` 라고 한다.  
- **지수부** 에는 `2^n` 에서 `n`의 값을 넣게 되는데, 지수부에 `n`의 값을 바로 넣는 것이 아니라 `bias`(편향)를 더한 값을 넣게 된다.
  - `32bit` 기준 지수부는 `8bit`를 이용하기에 음수를 포함한 `-127`\~`128`의 값을 표현해야했다. 최종적으로 부호비트를 별도로 사용하지 않고 `n`의 값에 127을 더하여 `0`\~`127`, `128`\~`255` 구간으로 표현하였다. 
  - 64bit 체계에서는 지수부가 `11bit`, 가수부가 `52bit`이며, `bias`는 1023이 된다.
    > -123.125의 예시를 보면 부호비트는 음수이므로 `-1`, 앞서 이진수로 변환한 값 `-1111011.001(2)`을 정규화 하면 `-1.111011001` \* `2^6` 이 된다. 그래서 가수부에는 `111011001`이 지수부에는 `6`+`127`인 `133`의 이진법 표기 `10000101`이 들어간다.

- 부동소수점 표현 방식은 고정소수점에 비해 복잡하지만 표현 가능한 수의 범위와 정밀도가 크다는 장점이 있다. 현재 대부분의 컴퓨터는 부동소수점 표현 방식을 사용한다.
- 다만 표현하고자 하는 수가 `1/2^n`의 합으로 나타내지지 않으면 이진법에서 무한소수가 되고 비트는 한정되어있기 때문에 오차가 발생한다.

<br/>

---

## Reference

📄http://generalnote.com/Computer-Fundamental/Number-System/Converting-Decimal-Integer-Fraction-to-Binary-Octal-Hexadecimal.php  
📄https://gsmesie692.tistory.com/94  
📄https://m.blog.naver.com/PostView.naver?isHttpsRedirect=true&blogId=7rlaguswns7&logNo=221349728794  
📄https://ko.wikipedia.org/wiki/%EB%B6%80%EB%8F%99%EC%86%8C%EC%88%98%EC%A0%90
